//
//  $Id: AHKShortTimeDateValueTransformer.m 95 2009-06-11 15:58:03Z fujidana $
//  Copyright (c) 2006-2009 Fujidana All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "AHKShortTimeDateValueTransformer.h"


@implementation AHKShortTimeDateValueTransformer

+ (Class)transformedValueClass
{
	return [NSString class];
}

+ (BOOL)allowsReverseTransformation
{
	return NO;
}

- (id)transformedValue:(id)value
{
	if (value == nil || [value isEqual:[NSNull null]]) return nil;
	
	// Attempt to get a reasonable value from the value object. 
	if ([value respondsToSelector:@selector(descriptionWithCalendarFormat:timeZone:locale:)])
	{
	// handles NSDate
		NSString *calendarFormat = [[NSUserDefaults standardUserDefaults] stringForKey:NSShortTimeDateFormatString];
		return [value descriptionWithCalendarFormat:calendarFormat timeZone:nil locale:nil];
	
	}
	else
	{
		[NSException raise: NSInternalInconsistencyException
					format: @"Value (%@) does not respond to -descriptionWithCalendarFormat:timeZone:locale:.",
		[value class]];
	}
	return nil;
}


@end
